%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      DefineMTFScene.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% File Version:   1
% Description:    This file defines the scene used to measure the resolution
%                 of the sensor array under test.
%-------------------------------------------------------------------------------

%scene = sceneCreate('slantedEdge');
scene = sceneCreate('slantedBar',[],[],waveLengths);

scene = sceneAdjustLuminance(scene,numCandelas);      % Candelas/m2
scene = sceneSet(scene,'distance',distanceToTarget);  % meters
scene = sceneSet(scene,'fov',fieldOfView);            % Field of view in degrees

% It is often useful to visualize the data in the scene window
vcAddAndSelectObject('scene',scene);
if showISET == TRUE,
   sceneWindow;
end

% End of File
